<?php

require_once('classes/XMLRPCParser.php');
require_once('classes/RESTParser.php');
require_once('classes/SAXParser.php');
require_once('classes/AmazonSAXParser.php');

$XMLRPCparser = new XMLRPCParser();
$RESTParser = new RESTParser();
$amazonXMLParser = new AmazonSAXParser();
$submitted = trim($_POST['numberSubmitted']);

switch ($submitted) {
	case strlen($submitted) == 12:
		$upcDbCall = "lookupUPC";
		break;
	case strlen($submitted) == 13:
		$upcDbCall = "lookupEAN";
		break;
	default:
		$upcDbCall = '';

}
$returnedXMLRPC = $XMLRPCparser->callService($upcDbCall, 
		$submitted, 
		'www.upcdatabase.com', 
		'/rpc', 
		80);

$restParams = array();
$restParams['Service'] = "AWSECommerceService";
$restParams['AWSAccessKeyId'] = 'TU WSTAW SWÓJ KOD';
$restParams['Operation'] = 'ItemLookup';
$restParams['XMLEscaping'] = 'Single';
$restParams['IdType'] = 'UPC';
$restParams['ResponseGroup'] = 'Large';
$restParams['ItemId'] = $returnedXMLRPC['upc'];
$restParams['SearchIndex'] = $_POST['SearchIndex'];

$amazonResponse = $RESTParser->callService($restParams, 'webservices.amazon.com', '/onca/xml', 'GET');
$amazonXMLParser->parse($amazonResponse);

?>
<html>
<head><title>Wyszukiwanie UPC</title></head>
<body>
<?php

if (is_array($amazonXMLParser->errorMessage)) {

?>
<h1>Błąd</h1>
Wystąpiły błędy podczas wyszukiwania:
	<ul>
	<?php foreach ($amazonXMLParser->errorMessage as $key => $value) { ?>
		<li><?= $value ?></li>	
	<?php } ?>
	</ul>

<?php } else { ?>
	<h1>Znalezione!</h1>
	<img src="<?= $amazonXMLParser->imageURL ?>" />
	<p>
	Cena: <?= $amazonXMLParser->formattedPrice ?>
	</p>
	<a href="AmazonCartAdd.php?asin=<?= $amazonXMLParser->asin ?>">Dodaj do koszyka</a>
<?php } ?>

<a href="UPCForm.php">Wyszukaj ponownie</a>
</body>
</html>